#include <RFM69.h>  
#include <SPI.h>
 
// ************************** RF Receiver Configuration ************************************
#define NETWORKID     100  //the same on all nodes that talk to each other
#define NODEID        1    //The unique identifier of this node
#define RECEIVER      2    //The recipient of packets
 
//Match frequency to the hardware version of the radio on your Feather
#define FREQUENCY     RF69_433MHZ
#define ENCRYPTKEY     "sampleEncryptKey" //exactly the same 16 characters/bytes on all nodes!
#define IS_RFM69HCW    true // set to 'true' if you are using an RFM69HCW module
//*********************************************************************************************

// ************************** PIN OUTPUT/INPUT Configuration **********************************
#define SERIAL_BAUD   115200

#define RFM69_CS      8
#define RFM69_IRQ     7
#define RFM69_IRQN    4  // Pin 7 is IRQ 4!
#define RFM69_RST     4

#define LED           13  // onboard blinky
#define Power_PIN 10
#define Door_Open_Close_PIN 11
#define Door_Sensor_PIN 12
//*********************************************************************************************

int16_t packetnum = 0;  // packet counter, we increment per xmission
unsigned long currentMillis = 0; //variable for timing purposes
long previousMillis = 0; //variable for timing purposes
long receive_interval = 35000; //if nothing received for 35s, reset RF module

int doorSensorVAL; 
boolean last_message_sent_was_open = false; //for door sensor
boolean last_message_sent_was_closed = false; //for door sensor
boolean last_message_received_was_open = false; //for transmission purposes
boolean last_message_received_was_closed = false; //for transmission purposes

int door_switch_status_counter=0; //counter increments every time door sensor is read, resents when sensor status sent
 
RFM69 radio = RFM69(RFM69_CS, RFM69_IRQ, IS_RFM69HCW, RFM69_IRQN);
 
void setup() {
  Serial.begin(SERIAL_BAUD);
  Serial.println("Feather RFM69HCW Receiver");
  
  initialize_radio();
  
  pinMode(LED, OUTPUT);
  pinMode(Power_PIN,OUTPUT);
  pinMode(Door_Open_Close_PIN,OUTPUT);
  pinMode(Door_Open_Close_PIN,OUTPUT);
  pinMode(Power_PIN,OUTPUT);
  pinMode(Door_Sensor_PIN, INPUT_PULLUP);

  //make sure extended
  digitalWrite(Door_Open_Close_PIN,LOW);  //relay off
  digitalWrite(Power_PIN,LOW);
  delay(10*1000); 
  
  digitalWrite(Door_Open_Close_PIN,HIGH);  //relay off
  digitalWrite(Door_Open_Close_PIN,HIGH);
  digitalWrite(Power_PIN,HIGH);      
 
  Serial.print("\nListening at ");
  Serial.print(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915);
  Serial.println(" MHz");
}


 
void loop() {
  currentMillis = millis();
  receive_packets();

  if(currentMillis - previousMillis > receive_interval){
    delay(200);
    Serial.println("NO RECEIVED PACKETS FOR 35 s STRAIGHT");
    Serial.println("Resetting RF module now");
    //reset and re-initialize radio
    initialize_radio();
    previousMillis = currentMillis;
    Serial.print("\nAfter Resetting, I'm now Listening at ");
    Serial.print(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915);
    Serial.println(" MHz");
  }
  
}






//----------------------- Functions -------------------------------
 
void Blink(byte PIN, byte DELAY_MS, byte loops)
{
  for (byte i=0; i<loops; i++)
  {
    digitalWrite(PIN,HIGH);
    delay(DELAY_MS);
    digitalWrite(PIN,LOW);
    delay(DELAY_MS);
  }
}

void receive_packets(){
  //***RECEIVE***
  //check if something was received (could be an interrupt from the radio)
  if (radio.receiveDone()){
    //print message received to serial
    Serial.print('[');Serial.print(radio.SENDERID);Serial.print("] ");
    Serial.print((char*)radio.DATA);
    Serial.print("   [RX_RSSI:");Serial.print(radio.RSSI);Serial.println("]");
    
    //check if received message contains "Open" or "Closed"
    if ((strstr((char *)radio.DATA, "Closed")) || (strstr((char *)radio.DATA, "Open")))
    {
      //check if sender wanted an ACK
      if (radio.ACKRequested())
      {
        radio.sendACK();
        Serial.println(" - ACK sent");
      }
      Blink(LED, 40, 3); //blink LED 3 times, 40ms between blinks
    }
    if((strstr((char *)radio.DATA, "Open")) || (strstr((char *)radio.DATA, "Closed"))){
      previousMillis = currentMillis;
    }
    
    if ((strstr((char *)radio.DATA, "Open")) && last_message_received_was_open == false){
      Serial.println("Its now ok to move the motors and transmit");
      last_message_received_was_open = true;
      last_message_received_was_closed = false;
      digitalWrite(Door_Open_Close_PIN,HIGH);
      //turn on power relay 
      digitalWrite(Power_PIN,LOW);
      delay(10*1000);
      //turn off the power relay
      digitalWrite(Power_PIN,HIGH);
      //turn off the control relay
      digitalWrite(Door_Open_Close_PIN,HIGH);
      
    }
    else if((strstr((char *)radio.DATA, "Closed")) &&  last_message_received_was_closed == false){
      Serial.println("Its now ok to move the motors and transmit");
      last_message_received_was_open = false;
      last_message_received_was_closed = true;
      digitalWrite(Door_Open_Close_PIN,LOW);
      //turn on power relay 
      digitalWrite(Power_PIN,LOW);
      delay(10*1000);
      //turn off the power relay
      digitalWrite(Power_PIN,HIGH);
      //turn off the control relay
      digitalWrite(Door_Open_Close_PIN,HIGH);      
     }
     door_switch_status_counter++;
     delay(500);
     transmit();
     Serial.print("\nListening at ");
     Serial.print(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915);
     Serial.println(" MHz");
     delay(2000);
     transmit();
     radio.receiveDone(); //put radio in RX mode
  }
}


void transmit(){
  delay(200);
  doorSensorVAL = digitalRead(Door_Sensor_PIN);
  //the door is open because magnet is NOT in contact with HEsensor  
  if(doorSensorVAL == LOW && (last_message_sent_was_open == false || door_switch_status_counter > 4)){
    door_switch_status_counter = 0;
    initialize_radio();
    delay(500);
    char radiopacket[20] = "sensorOpen";
    itoa(packetnum++, radiopacket+13, 10);
    Serial.print("Sending at 433MHz: "); Serial.println(radiopacket);
    if (radio.sendWithRetry(RECEIVER, radiopacket, strlen(radiopacket))) { //target node Id, message as string or byte array, message length
    last_message_sent_was_open = true;
    last_message_sent_was_closed = false;
    Serial.println("Acknowledge Received");
    Serial.println("Will not transmit now");
    char lastmessage[20] = "sensorOpen";
    Blink(LED, 50, 3); //blink LED 3 times, 50ms between blinks      
    }
    else{
      Serial.print("Sending at 433MHz: "); Serial.println(radiopacket);
    }
  }
  //the door is closed because magnet is in contact with HEsensor
  if(doorSensorVAL == HIGH && (last_message_sent_was_closed == false || door_switch_status_counter > 4)){
    door_switch_status_counter = 0;
    initialize_radio();
    delay(500);
    char radiopacket[20] = "sensorClosed";
    itoa(packetnum++, radiopacket+13, 10);
    Serial.print("Sending at 433MHz: "); Serial.println(radiopacket);
    if (radio.sendWithRetry(RECEIVER, radiopacket, strlen(radiopacket))) { //target node Id, message as string or byte array, message length 
    last_message_sent_was_open = false;
    last_message_sent_was_closed = true;
    Serial.println("Acknowledge Received");
    Serial.println("Will not transmit now");
    char lastmessage[20] = "sensorClosed";
    Blink(LED, 50, 3); //blink LED 3 times, 50ms between blinks
    }
    else{
      Serial.print("Sending at 433MHz: "); Serial.println(radiopacket);
    }
  } 
}

void initialize_radio(){
  // Hard Reset the RFM module
  pinMode(RFM69_RST, OUTPUT);
  digitalWrite(RFM69_RST, HIGH);
  delay(100);
  digitalWrite(RFM69_RST, LOW);
  delay(100);
  // Initialize radio
  radio.initialize(FREQUENCY,NODEID,NETWORKID);
  if (IS_RFM69HCW) {
    radio.setHighPower();    // Only for RFM69HCW & HW!
  }
  radio.setPowerLevel(31); // power output ranges from 0 (5dBm) to 31 (20dBm)
  radio.encrypt(ENCRYPTKEY);
}



